-- mods/titanium/init.lua
-- ===================
-- See LICENSE.txt for licensing and README.md for other information.

-- load support for intllib
local modpath = minetest.get_modpath(minetest.get_current_modname())
local S = minetest.get_translator("titanium")

-- Lapis Lazuli Ore
minetest.register_node("titanium:stone_with_titanium", {
	description = S("titanium Ore"),
	tiles = {"default_stone.png^titanium_mineral_titanium.png"},
	is_ground_content = true,
	groups = {cracky=2},
	drop = {
		max_items = 5,
		items = {
			{
				items = {'titanium:titanium 2'},  --The first and second drops ever
			},
			{
				items = {'titanium:titanium'},    --The 3rd drops with a 1/2 chance
				rarity = 1,
			},
			{
				items = {'titanium:titanium'},    --The 4th drops with a 1/3 chance
				rarity = 1,
			},
			{
				items = {'titanium:titanium'},    --The 5th drops with a 1/8 chance
				rarity = 1,
			},
		}
	},
	sounds = default.node_sound_stone_defaults(),
})

-- Lapis Item
minetest.register_craftitem("titanium:titanium", {
	description = S("titanium"),
	inventory_image = "titanium.png",
})


minetest.register_node("titanium:titaniumblock", {
	description = S("titanium Block"),
	tiles = {"titanium_titaniumblock.png"},
	is_ground_content = true,
	groups = {cracky = 1, level = 2},
	sounds = default.node_sound_stone_defaults(),
})


minetest.register_craft({
	output = 'titanium:titanium',
	recipe = {
		{'titanium:titanium', 'titanium:titanium', 'titanium:titanium'},
		{'titanium:titanium', 'titanium:titanium', 'titanium:titanium'},
		{'titanium:titanium', 'titanium:titanium', 'titanium:titanium'},
	}
})

-- Lapis Items from Lapis Block Crafting
minetest.register_craft({
	output = 'titanium:titanium 9',
	recipe = {
		{'titanium:titanium'},
	}
})

-- Ore generation
-- -128 <-> -255
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "titanium:stone_with_titanium",
	wherein        = "default:stone",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 5,
	clust_size     = 3,
	height_min     = -31000,
	height_max     = -35,
})

-- -256 <-> -31000
minetest.register_ore({
	ore_type       = "scatter",
	ore            = "titanium:stone_with_titanium",
	wherein        = "default:stone",
	clust_scarcity = 15 * 15 * 15,
	clust_num_ores = 6,
	clust_size     = 4,
	height_min     = -31000,
	height_max     = -15,
})


